#version 330
#extension GL_EXT_gpu_shader4 : enable
// Kaleidoscopic demoMod01.fsh by  darkeclipz

//https://www.shadertoy.com/view/WdBGzV
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.177   //0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

mat2 r2(float angle) { return mat2(cos(angle), -sin(angle), sin(angle), cos(angle)); }
#define R iResolution.xy
#define Iterations 10.
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    // Normalized pixel coordinates (from 0 to 1)
    vec2 uv = (2.*gl_FragCoord.xy-R)/iResolution.y;
	vec3 col = vec3(0);
    float s = iTime/16. * cos(iTime/32.);

    // https://www.shadertoy.com/view/Mss3Wf
    for(float i=0.; i < Iterations; i++) {
    	uv = abs(uv) - s; 
        uv.xy *= r2(iTime/16. + 2.);
        uv *= 1.08;
    }
    
    float dist = length(fract(2.*uv));
    vec3 rainbow = cos(vec3(0,2,4) + iTime + 2.*uv.xyx);
    col = dist*rainbow;
    
    float gridSize = 3.;
    float gridWidth = 0.04;
    vec2 grid = smoothstep(gridWidth, 0., abs(fract(gridSize*uv)-gridWidth));
    col = mix(col, vec3(1), clamp(grid.x + grid.y, 0., 1.)); 

    // Output to screen
    gl_FragColor = vec4(col,1.0);
}
